package com.xebialabs.xlrelease.lookup.delegate

import com.fasterxml.jackson.core.`type`.TypeReference
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Delegate, Parameters}
import com.xebialabs.xlrelease.lookup.api.internal.LookupResultElement
import com.xebialabs.xlrelease.runner.impl.{ContainerScriptException, RunnerScriptService}
import com.xebialabs.xlrelease.service.ConfigurationVariableService
import grizzled.slf4j.{Logger, Logging}

import java.util
import java.util.{List => JList, Map => JMap}

object RemoteScriptLookupDelegate extends BaseLookupDelegate with Logging {

  // remove ugly '$' at the end of this singleton when logging
  override def logger: Logger = Logger(this.getClass.getName.dropRight(1))

  lazy val scriptService: RunnerScriptService = springBean[RunnerScriptService]
  private lazy val configurationVariableService = springBean[ConfigurationVariableService]

  @Delegate(name = "remoteScriptLookup")
  override def lookup(ci: ConfigurationItem, methodName: String, attrs: JMap[String, String], parameters: Parameters): JList[LookupResultElement] = {
    configurationVariableService.resolveFromCi(ci)()
    val script = if (attrs.containsKey("script")) {
      attrs.get("script")
    } else {
      throw ContainerScriptException(s"Container script missing in method delegate attribute setting")
    }

    val inputParameters: util.Map[String, AnyRef] = new util.HashMap[String, AnyRef]()
    inputParameters.put("_ci", ci) // writing it as json string
    inputParameters.put("_parameters", parameters) // writing it as json string
    inputParameters.put("_attributes", attrs) // writing it as json string

    scriptService.executeScript[JList[LookupResultElement]](
      script,
      inputParameters,
      new TypeReference[JList[LookupResultElement]] {}
    )
  }

}
