package com.xebialabs.xlrelease.lookup.delegate

import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Parameters}
import com.xebialabs.xlrelease.lookup.api.internal.LookupResultElement
import com.xebialabs.xlrelease.script._
import com.xebialabs.xlrelease.script.builder.{ScriptContextBuilder, _}
import com.xebialabs.xlrelease.service.ConfigurationVariableService

import java.util
import java.util.{List => JList, Map => JMap}
import javax.script.ScriptContext.ENGINE_SCOPE
import scala.util.Using

trait ScriptLookupDelegate extends BaseLookupDelegate {

  def scriptSuffix: String

  def scriptService: DefaultScriptService

  private lazy val configurationVariableService = springBean[ConfigurationVariableService]

  override def lookup(ci: ConfigurationItem, methodName: String, attrs: JMap[String, String], parameters: Parameters): JList[LookupResultElement] = {
    configurationVariableService.resolveFromCi(ci)()
    Using.resource(new LookupDelegateScriptContextBuilder(ci, methodName, attrs, parameters, scriptSuffix).build()) { scriptContext =>
      doExecuteScript(scriptContext)
      scriptContext.getAttribute("result").asInstanceOf[JList[LookupResultElement]]
    }
  }

  protected def doExecuteScript(scriptContext: XlrScriptContext): Unit
}

private class LookupDelegateScriptContextBuilder(ci: ConfigurationItem,
                                                 methodName: String,
                                                 attrs: util.Map[String, String],
                                                 parameters: Parameters,
                                                 scriptSuffix: String) extends ScriptContextBuilder {
  withScriptApi().withLogger()

  scriptSuffix match {
    case "groovy" => withOpenApi()
    case "py" => withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()
  }

  override def doBuild(context: XlrScriptContext): Unit = {
    EncryptionHelper.decrypt(ci)
    context.setAttribute("_ci", ci, ENGINE_SCOPE)
    context.setAttribute("_parameters", parameters, ENGINE_SCOPE)
    context.setAttribute("_attributes", attrs, ENGINE_SCOPE)
    context.addProperties(ci, ci.getType.getDescriptor.getPropertyDescriptors)
    context.addProperties(parameters, parameters.getType.getDescriptor.getPropertyDescriptors)

    val scriptLocation = if (attrs.containsKey("script")) {
      attrs.get("script")
    } else {
      s"${ci.getType.getPrefix}/${ci.getType.getName}_${methodName}.${scriptSuffix}"
    }
    context.addScript(XlrScript.byResource(resource = scriptLocation, wrap = false, checkPermissions = false))
  }

}
