package com.xebialabs.xlrelease.actors.kryo.serializers

import com.esotericsoftware.kryo.kryo5.io.{Input, Output}
import com.esotericsoftware.kryo.kryo5.{Kryo, Serializer}
import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper
import com.xebialabs.xlrelease.serialization.json.xltype.CiJson2Reader
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException

object XlrValidationsFailedExceptionSerializer
  extends Serializer[XlrValidationsFailedException] with ExceptionSerializerSupport[XlrValidationsFailedException] {
  override def write(kryo: Kryo, output: Output, item: XlrValidationsFailedException): Unit = {
    writeBasic(kryo, output, item)
    val ciJson = CiSerializerHelper.serialize(item.getEntity)
    kryo.writeClassAndObject(output, ciJson)
  }

  override def read(kryo: Kryo, input: Input, itemType: Class[_ <: XlrValidationsFailedException]): XlrValidationsFailedException = {
    val data = readBasic(kryo, input)
    val ciJson = kryo.readClassAndObject(input).asInstanceOf[String]
    val ciConverter = new PasswordEncryptingCiConverter()
    ciConverter.setReadValidationMessages(true)
    val ciJsonReader = CiJson2Reader.create(ciJson)
    val ci = ciConverter.readCi(ciJsonReader)
    val ex = new XlrValidationsFailedException(ci)
    ex.setStackTrace(data.stackTrace)
    ex
  }
}
