package com.xebialabs.xlrelease.actors.kryo

import com.esotericsoftware.kryo.kryo5.io.{Input, Output}
import com.esotericsoftware.kryo.kryo5.{Kryo, Serializer}
import com.xebialabs.xlrelease.actors.KryoInitializer
import com.xebialabs.xlrelease.actors.kryo.serializers.ExceptionSerializerSupport
import com.xebialabs.xlrelease.actors.kryo.serializers.ExceptionSerializerSupport.BasicExceptionData

object JavaExceptionSerializers extends KryoInitializer {

  override def postInit(kryo: Kryo): Unit = {
    basicExceptionSerializer(data => new IllegalStateException(data.msg))
    basicExceptionSerializer(data => new IllegalAccessException(data.msg))
    basicExceptionSerializer(data => new IllegalArgumentException(data.msg))
    basicExceptionSerializer(data => new NullPointerException(data.msg))
  }

  private def basicExceptionSerializer[T <: Exception](create: BasicExceptionData => T): Serializer[T] = {
    new Serializer[T] with ExceptionSerializerSupport[T] {
      override def write(kryo: Kryo, output: Output, item: T): Unit = {
        writeBasic(kryo, output, item)
      }

      override def read(kryo: Kryo, input: Input, itemType: Class[_ <: T]): T = {
        val basicData = readBasic(kryo, input)
        val ex = create(basicData)
        ex.setStackTrace(basicData.stackTrace)
        ex.initCause(basicData.cause)
        ex
      }
    }
  }

  override def getOrder: Int = 2
}
