package com.xebialabs.xlrelease.actors.kryo.serializers

import com.esotericsoftware.kryo.kryo5.io.{Input, Output}
import com.esotericsoftware.kryo.kryo5.{Kryo, Serializer}
import com.xebialabs.xlrelease.scm.connector.ScmException

object ScmExceptionSerializer extends Serializer[ScmException] with ExceptionSerializerSupport[ScmException] {
  override def write(kryo: Kryo, output: Output, item: ScmException): Unit = {
    writeBasic(kryo, output, item)
    kryo.writeClassAndObject(output, item.statusCode)
  }

  override def read(kryo: Kryo, input: Input, itemType: Class[_ <: ScmException]): ScmException = {
    val basic = readBasic(kryo, input)
    val statusCode = kryo.readClassAndObject(input).asInstanceOf[Int]
    ScmException(basic.msg, basic.cause, statusCode)
  }
}
