package com.xebialabs.xlrelease.actors.kryo.serializers

import com.esotericsoftware.kryo.kryo5.io.{Input, Output}
import com.esotericsoftware.kryo.kryo5.{Kryo, Serializer}
import com.xebialabs.xlrelease.versioning.TemplateVersioningException

object TemplateVersioningExceptionSerializer extends Serializer[TemplateVersioningException] with ExceptionSerializerSupport[TemplateVersioningException] {
  override def write(kryo: Kryo, output: Output, item: TemplateVersioningException): Unit = {
    writeBasic(kryo, output, item)
    kryo.writeClassAndObject(output, item.statusCode)
  }

  override def read(kryo: Kryo, input: Input, itemType: Class[_ <: TemplateVersioningException]): TemplateVersioningException = {
    val basic = readBasic(kryo, input)
    val statusCode = kryo.readClassAndObject(input).asInstanceOf[Int]
    TemplateVersioningException(basic.msg, basic.cause, statusCode)
  }
}
