package com.xebialabs.xlrelease.actors.kryo.serializers

import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.{Kryo, Serializer}
import com.xebialabs.xlrelease.actors.RemoteException

object RemoteExceptionSerializer extends Serializer[RemoteException] with ExceptionSerializerSupport[RemoteException] {
  override def write(kryo: Kryo, output: Output, item: RemoteException): Unit = {
    writeBasic(kryo, output, item)
    kryo.writeClassAndObject(output, item.responseStatusCode)
    kryo.writeClassAndObject(output, item.suppressStackTrace)
  }

  override def read(kryo: Kryo, input: Input, itemType: Class[_ <: RemoteException]): RemoteException = {
    val data = readBasic(kryo, input)
    val statusCode = kryo.readClassAndObject(input).asInstanceOf[Int]
    val suppressStackTrace = kryo.readClassAndObject(input).asInstanceOf[Boolean]
    val ex = new RemoteException()
    ex.msg = data.msg
    ex.setStackTrace(data.stackTrace)
    ex.initCause(data.cause)
    ex.suppressStackTrace = suppressStackTrace
    ex.responseStatusCode = statusCode
    ex
  }
}
