package com.xebialabs.xlrelease.actors.kryo.serializers

import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.{Kryo, Serializer}
import com.xebialabs.xlrelease.actors.kryo.serializers.ExceptionSerializerSupport.BasicExceptionData

trait ExceptionSerializerSupport[T <: Exception] { self: Serializer[_ <: T] =>

  def writeBasic(kryo: Kryo, output: Output, item: T): Unit = {
    kryo.writeClassAndObject(output, item.getMessage)
    kryo.writeClassAndObject(output, item.getStackTrace)
    // write cause only if it's already registered with Kryo
    val cause = Option(item.getCause).flatMap(cause =>
      Option(kryo.getClassResolver.getRegistration(cause.getClass))
        .map(_ => item.getCause)
    ).orNull
    kryo.writeClassAndObject(output, cause)
  }

  def readBasic(kryo: Kryo, input: Input): BasicExceptionData = {
    val msg = kryo.readClassAndObject(input).asInstanceOf[String]
    val stackTrace = kryo.readClassAndObject(input).asInstanceOf[Array[StackTraceElement]]
    val cause = kryo.readClassAndObject(input).asInstanceOf[Throwable]
    BasicExceptionData(msg, stackTrace, cause)
  }
}

object ExceptionSerializerSupport {
  case class BasicExceptionData(msg: String, stackTrace: Array[StackTraceElement], cause: Throwable)


}
