package com.xebialabs.xlrelease.actors.kryo.serializers

import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.{Kryo, Serializer}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.service.validation.Validator.ValidationsFailedException

// TODO check what happened to XlrValidationsFailedException
object ValidationsFailedExceptionSerializer extends Serializer[ValidationsFailedException]
  with DeployitExceptionSerializerSupport[ValidationsFailedException] {

  override def write(kryo: Kryo, output: Output, item: ValidationsFailedException): Unit = {
    writeDeployitException(kryo, output, item)
  }

  override def read(kryo: Kryo, input: Input, itemType: Class[_ <: ValidationsFailedException]): ValidationsFailedException = {
    val data = readDeployitException(kryo, input)
    val ex = if (data.entity != null) {
      new ValidationsFailedException(data.entity)
    } else if (data.entityList != null) {
      new ValidationsFailedException(data.entityList)
    } else {
      val e = new ValidationsFailedException(null.asInstanceOf[ConfigurationItem])
      e.add(s"Internal error: entity was not (de)serialized via ${this.getClass}")
      e
    }
    if (!ex.hasErrors) {
      ex.addAll(data.errors)
    }
    ex.setStackTrace(data.stackTrace)
    ex.initCause(data.cause)
    ex
  }
}
