import { templateTile, initialState } from './template-tile.reducer';
import { HomeTemplate } from '../active-template-tile.component';

const { loadTopTemplates, setTopTemplates } = templateTile.actions;

describe('template tile reducer', () => {
    it('should have the initial state', () => {
        expect(templateTile.name).toBe('templateTile');
        expect(Object.keys(templateTile.actions)).toStrictEqual(['loadTopTemplates', 'setTopTemplates']);
        expect(templateTile.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    describe('reducers', () => {
        describe('loadTopTemplates', () => {
            it('should set isLoading to true', () => {
                expect(templateTile.reducer(initialState, loadTopTemplates())).toStrictEqual({ ...initialState, isLoading: true });
            });
        });

        describe('setTopTemplates', () => {
            const topTemplates: Array<HomeTemplate> = [
                {
                    releaseId: 'releaseId',
                    releaseTitle: 'Test Release',
                    folderName: 'test',
                    folderId: 'folderId',
                    folderPath: '/',
                    lastEditedByUser: 1688372003150,
                    releaseCount: 0,
                },
            ];

            it('should set top templates and set isLoading to false', () => {
                expect(templateTile.reducer(initialState, setTopTemplates(topTemplates))).toStrictEqual({
                    ...initialState,
                    topTemplates,
                    isLoading: false,
                });
            });
        });
    });
});
