import React from 'react';
import { Provider } from 'react-redux';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { store } from '@xlr-ui/app/js/app-config';
import { WorkflowTile, WorkflowTileProps } from './workflow-tile.component';

export const WorkflowTileContainer = (props: WorkflowTileProps) => {
    return (
        <DotThemeProvider>
            <Provider store={store}>
                <WorkflowTile {...props} />
            </Provider>
        </DotThemeProvider>
    );
};
