import { releaseTile, initialState } from './release-tile.reducer';
import { HomeRelease } from '../active-release-tile.component';

const { loadTopReleases, setTopReleases } = releaseTile.actions;

describe('release tile reducer', () => {
    it('should have the initial state', () => {
        expect(releaseTile.name).toBe('releaseTile');
        expect(Object.keys(releaseTile.actions)).toStrictEqual(['loadTopReleases', 'setTopReleases']);
        expect(releaseTile.reducer(undefined, { type: 'default' })).toBe(initialState);
    });

    describe('reducers', () => {
        describe('loadTopReleases', () => {
            it('should set isLoading to true', () => {
                expect(releaseTile.reducer(initialState, loadTopReleases())).toStrictEqual({ ...initialState, isLoading: true });
            });
        });

        describe('setTopReleases', () => {
            const topReleases: Array<HomeRelease> = [
                {
                    releaseId: 'releaseId',
                    releaseTitle: 'Test Release',
                    releaseStartDate: 1689771884388,
                    releaseEndDate: 1690187050829,
                    releaseStatus: 'IN_PROGRESS',
                    folderName: 'test',
                    folderId: 'folderId',
                    folderPath: '/',
                    lastEditedByUser: 1690187050870,
                },
            ];

            it('should set top releases and set isLoading to false', () => {
                expect(releaseTile.reducer(initialState, setTopReleases(topReleases))).toStrictEqual({
                    ...initialState,
                    topReleases,
                    isLoading: false,
                });
            });
        });
    });
});
