import React, { useState } from 'react';
import { DotDialog, DotThemeProvider, DotTypography } from '@digital-ai/dot-components';
import constant from 'lodash/constant';
import { ButtonWithLink, CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';

export interface WelcomeTileProps {
    description: string;
    title: string;
}

export const WelcomeTile = ({ description, title }: WelcomeTileProps) => {
    const [isDialogOpen, setDialogOpen] = useState(false);
    const handleButtonClick = () => {
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore pendo is global variable
        const pendoClient = typeof pendo !== 'undefined' ? pendo : { isSendingEvents: constant(false) };
        if (pendoClient.isSendingEvents()) {
            // leaving this here, pendo will trigger the action on clicky
        } else {
            setDialogOpen(true);
        }
    };

    const primaryButton: ButtonWithLink = {
        buttonType: 'primary',
        buttonCaption: 'Take quick tour',
        'data-testid': 'welcome-tile-btn', // this is needed for pendo, do not change it
        onClick: handleButtonClick,
    };

    return (
        <DotThemeProvider>
            <CommonCardTileComponent description={description} illustrationId="launch" isMarkdown={true} primaryButton={primaryButton} title={title} />
            {isDialogOpen && (
                <DotDialog
                    cancelButtonVisible={false}
                    closeIconVisible={true}
                    closeOnClickAway={false}
                    onSubmit={() => setDialogOpen(false)}
                    open={isDialogOpen}
                    submitButtonProps={{ label: 'Close' }}
                    title="Content not available"
                >
                    <DotTypography>
                        You are seeing this message because your Release product setup has disabled guides and in-product analytics, or you are in an air-gapped
                        environment. Please contact your Release administrator for further assistance.
                    </DotTypography>
                </DotDialog>
            )}
        </DotThemeProvider>
    );
};
