import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { RootState } from '@xlr-ui/app/js/store.types';
import { HomeRelease } from '../active-release-tile.component';

export interface ReleaseTileState {
    isLoading: boolean;
    topReleases: Array<HomeRelease>;
}

export const initialState: ReleaseTileState = {
    isLoading: true,
    topReleases: [],
};

export const releaseTile = createSlice({
    name: 'releaseTile',
    initialState,
    reducers: {
        loadTopReleases: (state) => {
            state.isLoading = true;
        },
        setTopReleases: (state, action: PayloadAction<Array<HomeRelease>>) => {
            state.topReleases = action.payload;
            state.isLoading = false;
        },
    },
});

export const getReleaseTileState = (state: RootState): ReleaseTileState => state.releaseTile;
