import React from 'react';
import { DotAvatar, DotTypography } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { CommonTileHeader } from './common-tile-header.component';

describe('CommonTileHeader', () => {
    const avatarIcon = 'template';
    const title = 'Templates';
    const subtitle = 'Most recent';
    const endContent = <div>This is some end content...</div>;

    const mount = () => {
        return mountWithTheme(<CommonTileHeader avatarIcon={avatarIcon} endContent={endContent} subtitle={subtitle} title={title} />);
    };

    const getTitleAvatar = (wrapper: ReactWrapper) => wrapper.find(DotAvatar).at(0);
    const getTitle = (wrapper: ReactWrapper) => wrapper.find(DotTypography).at(0);
    const getSubtitle = (wrapper: ReactWrapper) => wrapper.find(DotTypography).at(1);
    const getEndContent = (wrapper: ReactWrapper) => wrapper.find('.header-tile-end-content');

    it('should render with correct props', () => {
        const wrapper = mount();

        const avatarProps = getTitleAvatar(wrapper).props();
        expect(avatarProps.alt).toBe(avatarIcon);
        expect(avatarProps.iconId).toBe(avatarIcon);
        expect(avatarProps.type).toBe('icon');

        const titleProps = getTitle(wrapper).props();
        expect(titleProps.variant).toBe('h2');
        expect(titleProps.children).toBe(title);

        const subtitleProps = getSubtitle(wrapper).props();
        expect(subtitleProps.className).toBe('header-tile-subtitle');
        expect(subtitleProps.variant).toBe('body1');
        expect(subtitleProps.children).toBe(subtitle);

        const headerEndContent = getEndContent(wrapper);
        expect(headerEndContent).toExist();
        expect(headerEndContent.prop('className')).toBe('header-tile-end-content');
    });
});
