import React, { ReactNode } from 'react';
import classNames from 'classnames';
import { DotAvatar, DotTypography } from '@digital-ai/dot-components';
import './common-tile-header.component.less';

interface CommonTileHeaderProps {
    avatarIcon?: string;
    endContent?: ReactNode;
    subtitle?: string;
    title: string;
}

export const CommonTileHeader = ({ avatarIcon, endContent, subtitle, title }: CommonTileHeaderProps) => {
    return (
        <div className={classNames('common-tile-header', { 'with-margin': !!avatarIcon })}>
            <div className="header-tile-main">
                {avatarIcon && <DotAvatar alt={avatarIcon} iconId={avatarIcon} type="icon" />}
                <div>
                    <DotTypography variant="h2">{title}</DotTypography>
                    <DotTypography className="header-tile-subtitle" variant="body1">
                        {subtitle}
                    </DotTypography>
                </div>
            </div>
            {endContent && <div className="header-tile-end-content">{endContent}</div>}
        </div>
    );
};
