import { formatReleaseDuration, isReleaseOverdue } from './helpers';

describe('release tile helper functions', () => {
    describe('formatReleaseDuration', () => {
        it('should return duration text in correct format', () => {
            expect(formatReleaseDuration(0, 0, 0)).toStrictEqual('0m');
            expect(formatReleaseDuration(0, 0, 1)).toStrictEqual('1m');
            expect(formatReleaseDuration(0, 8, 480)).toStrictEqual('8h ');
            expect(formatReleaseDuration(2, 48, 2880)).toStrictEqual('2d ');
            expect(formatReleaseDuration(2, 56, 3360)).toStrictEqual('2d 8h ');
            expect(formatReleaseDuration(2, 48, 2891)).toStrictEqual('2d 11m');
            expect(formatReleaseDuration(0, 2, 131)).toStrictEqual('2h 11m');
        });
    });

    describe('isReleaseOverdue', () => {
        it('should not be overdue if release is completed or aborted', () => {
            expect(isReleaseOverdue({ releaseStatus: 'COMPLETED', releaseEndDate: 1 } as never)).toBe(false);
            expect(isReleaseOverdue({ releaseStatus: 'ABORTED', releaseEndDate: 1 } as never)).toBe(false);
        });
        it('should not be overdue if release end date is in future', () => {
            expect(isReleaseOverdue({ releaseStatus: 'IN_PROGRESS', releaseEndDate: Infinity } as never)).toBe(false);
        });
        it('should be overdue if release end date is in past', () => {
            expect(isReleaseOverdue({ releaseStatus: 'IN_PROGRESS', releaseEndDate: 1 } as never)).toBe(true);
        });
    });
});
