import React from 'react';
import { DotIllustration, DotTypography } from '@digital-ai/dot-components';
import './empty-data.component.less';

export interface EmptyDataProps {
    illustrationId?: string;
    message: string;
}

export const EmptyData = ({ illustrationId, message }: EmptyDataProps) => {
    return (
        <div className="empty-data">
            <DotTypography variant="body1">{message}</DotTypography>
            {illustrationId && <DotIllustration illustrationId={illustrationId} />}
        </div>
    );
};
