import React from 'react';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme, ReactWrapper, act } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';
import { TemplateTileComponent, TemplateTileProps } from './template-tile.component';
import { ActiveTemplateTile } from './active-template-tile.component';
import { ActiveTileSkeleton } from '../../CommonCardTile/active-tile.skeleton';
import { initialState as templateTileInitialState } from './ducks/template-tile.reducer';

describe('TemplateTileComponent', () => {
    let wrapper: ReactWrapper;
    const dispatch = jest.fn();

    const title = 'Templates';
    const description = 'Test template description';

    const defaultProps: TemplateTileProps = {
        title,
        description,
    };

    const defaultState = {
        templateTile: { ...templateTileInitialState, isLoading: false },
    };

    const mount = async (props: TemplateTileProps = defaultProps, state = defaultState) => {
        await act(async () => {
            wrapper = mountWithStoreAndTheme(<TemplateTileComponent {...props} />, dispatch, state);
        });
    };

    const getCommonCardTileComponent = () => wrapper.find(CommonCardTileComponent);
    const getFirstButton = () => wrapper.find(DotButton).at(0);
    const getSecondButton = () => wrapper.find(DotButton).at(1);
    const getActiveTemplateTile = () => wrapper.find(ActiveTemplateTile);
    const getActiveTileSkeleton = () => wrapper.find(ActiveTileSkeleton);

    it('should render with correct props', async () => {
        await mount();
        const props = getCommonCardTileComponent().props();
        expect(props.title).toBe(title);
        expect(props.description).toBe(description);
        expect(props.imageLink).toBe('static/24.3.7-511.2018/styles/img/timeline_monochromatic.svg');
        expect(props.primaryButton.buttonCaption).toBe('View templates');
        expect(props.primaryButton.buttonType).toBe('text');
        expect(props.secondaryButton?.buttonCaption).toBe('Create template');
        expect(props.secondaryButton?.buttonType).toBe('outlined');
        expect(getActiveTemplateTile()).not.toExist();
        expect(getActiveTileSkeleton()).not.toExist();
    });

    it('should handle click event', async () => {
        await mount();
        const firstButton = getFirstButton();
        firstButton.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/templates`);
        const secondButton = getSecondButton();
        secondButton.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/templates/create?fromHome=true`);
    });

    it('should show active tile skeleton if loading', async () => {
        await mount(defaultProps, { ...defaultState, templateTile: { ...templateTileInitialState, isLoading: true } });
        expect(getActiveTileSkeleton()).toExist();
    });
});
