import React from 'react';
import { DotButton, DotCardFooter } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper, act } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { AnnouncementTile, AnnouncementTileProps } from './announcement-tile.component';
import { CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';

describe('AnnouncementTile', () => {
    let wrapper: ReactWrapper;
    const description = 'my description';
    const buttonCaption = 'my button';
    const buttonLink = '#/button';
    const buttonType = 'text';
    const imageLink = 'egg.png';
    const title = 'title';

    const defaultProps: AnnouncementTileProps = { description, buttonCaption, buttonLink, buttonType, title, imageLink };

    const mount = async (props: AnnouncementTileProps = defaultProps) => {
        await act(async () => {
            wrapper = mountWithTheme(<AnnouncementTile {...props} />);
        });
    };

    const getButton = () => wrapper.find(DotCardFooter).find(DotButton);
    const getCommonCardTileComponent = () => wrapper.find(CommonCardTileComponent);

    it('should render', async () => {
        await mount();
        const commonCard = getCommonCardTileComponent();
        const commonCardProps = commonCard.props();
        expect(commonCardProps.title).toBe(title);
        expect(commonCardProps.secondaryButton).toBeUndefined();
        expect(commonCardProps.primaryButton.buttonType).toBe(buttonType);
        expect(commonCardProps.primaryButton.buttonCaption).toBe(buttonCaption);
        expect(commonCardProps.description).toBe(description);
        expect(commonCardProps.imageLink).toBe(imageLink);
        expect(commonCardProps.isMarkdown).toBe(true);
    });

    it('should handle internal links on click', async () => {
        await mount();
        const button = getButton();
        button.invoke('onClick')?.('' as never);
        expect(window.location.href).toStrictEqual(`http://localhost/#/button`);
    });

    it('should handle external links on click', async () => {
        jest.spyOn(window, 'open').mockImplementation(() => null);
        await mount({ ...defaultProps, buttonLink: 'https://www.coolblue.nl' });
        const button = getButton();
        button.invoke('onClick')?.('' as never);
        expect(window.open).toHaveBeenCalledWith('https://www.coolblue.nl', '_blank');
    });
});
