import {
    getHoursRemainderWithinDay,
    getMinutesRemainderWithinHour,
    isOverdue,
} from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/scheduling/helper';
import { HomeRelease } from '../active-release-tile.component';

export const formatReleaseDuration = (days: number, hours: number, minutes: number) => {
    const daysText = days > 0 ? `${days}d ` : '';
    const hoursText = getHoursRemainderWithinDay(hours) > 0 ? `${getHoursRemainderWithinDay(hours)}h ` : '';
    const minutesText = getMinutesRemainderWithinHour(minutes) > 0 ? `${getMinutesRemainderWithinHour(minutes)}m` : '';
    return `${daysText}${hoursText}${minutesText}` || '0m';
};

export const isReleaseOverdue = (release: HomeRelease) => {
    if (!['COMPLETED', 'ABORTED'].includes(release.releaseStatus.toUpperCase())) {
        return isOverdue(release.releaseEndDate);
    } else {
        return false;
    }
};
