import { all, call, put, takeLatest } from 'redux-saga/effects';
import { IHttpResponse } from 'angular';
import { httpGET } from '../../../../../../../../../../../core/xlr-ui/app/features/common/services/http';
import { releaseTile } from './release-tile.reducer';
import { HomeRelease } from '../active-release-tile.component';

const { loadTopReleases, setTopReleases } = releaseTile.actions;

export function* loadTopReleasesSaga() {
    const { data }: IHttpResponse<Array<HomeRelease>> = yield call(httpGET, 'home-tile/releases');
    yield put(setTopReleases(data));
}

export default function* releaseTileSaga() {
    yield all([takeLatest(loadTopReleases, loadTopReleasesSaga)]);
}
