import React from 'react';
import { DotTypography } from '@digital-ai/dot-components';
import { mountWithTheme, ReactWrapper } from '../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { EmptyData, EmptyDataProps } from './empty-data.component';

describe('EmptyData', () => {
    const imageLink = 'static/24.1.10/styles/img/workflows_forms.svg';
    const message = 'No data found.';

    const defaultProps: EmptyDataProps = { imageLink, message };

    const mount = (props: EmptyDataProps = defaultProps) => {
        return mountWithTheme(<EmptyData {...props} />);
    };

    const getMessage = (wrapper: ReactWrapper) => wrapper.find(DotTypography);
    const getImage = (wrapper: ReactWrapper) => wrapper.find('img');

    it('should render properly', () => {
        const wrapper = mount();
        expect(getMessage(wrapper)).toHaveText(message);
        expect(getImage(wrapper).props().src).toBe(imageLink);
    });
});
