import React from 'react';
import { DotThemeProvider } from '@digital-ai/dot-components';
import { ButtonType, ButtonWithLink, CommonCardTileComponent } from '../../CommonCardTile/common-card-tile.component';

export interface AnnouncementTileProps {
    buttonCaption: string;
    buttonLink: string;
    buttonType: ButtonType;
    description: string;
    imageLink?: string;
    title: string;
}

export const AnnouncementTile = ({ buttonCaption, buttonLink, buttonType = 'outlined', description = '', imageLink, title }: AnnouncementTileProps) => {
    const handleButtonClick = () => {
        if (!buttonLink) return;
        if (buttonLink.startsWith('#')) {
            window.location.href = buttonLink;
        } else {
            window.open(buttonLink, '_blank');
        }
    };

    const primaryButton: ButtonWithLink = {
        buttonType,
        buttonCaption,
        onClick: handleButtonClick,
    };

    return (
        <DotThemeProvider>
            <CommonCardTileComponent description={description} imageLink={imageLink} isMarkdown={true} primaryButton={primaryButton} title={title} />
        </DotThemeProvider>
    );
};
