package xlrelease

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.security.Permissions

BaseConfigurationItem.metaClass.propertyMissing << { String name, Object value ->
  if (delegate.hasProperty(name)) {
    delegate.setProperty(name, value)
  } else {
    throw new IllegalArgumentException("Type ${delegate.type} has no property ${name}")
  }
}

BaseConfigurationItem.metaClass.propertyMissing << { String name ->
  def result = null
  if (delegate.hasProperty(name)) {
    result = delegate.getProperty(name)
  } else {
    throw new IllegalArgumentException("Type ${delegate.type} has no property ${name}")
  }
  result
}

templateApi = wrap(_templateApi)
releaseApi = wrap(_releaseApi)
phaseApi = wrap(_phaseApi)
taskApi = wrap(_taskApi)
folderApi = wrap(_folderApi)
userApi = wrap(_userApi)
dslApi = wrap(_dslApi)
configurationApi = wrap(_configurationApi)
rolesApi = wrap(_rolesApi)
permissionsApi = wrap(_permissionsApi)
riskApi = wrap(_riskApi)
wrap(_dsl)

def wrap(apiService) {
  apiService.metaClass.invokeMethod = { String name, args ->
    def calledMethod = delegate.metaClass.getMetaMethod(name, args)
    if (Permissions.getAuthenticatedUserName() == null) {
      throw new RuntimeException("A 'Run automated tasks as user' and 'Password' properties has to be set in order to use XL Release's API")
    }

    calledMethod.invoke(delegate, args)
  }
  apiService
}

def getVersion() {
  _version
}