/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslFormatter$;
import com.xebialabs.xlrelease.dsl.service.renderer.DefaultRenderer;
import com.xebialabs.xlrelease.dsl.service.renderer.DslRendererContext;
import com.xebialabs.xlrelease.repository.Ids;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u00015\u00111\u0002R:m\u000bb\u0004xN\u001d;fe*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!A\u0002eg2T!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005yA-\u001a4bk2$(+\u001a8eKJ,'\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0005\u0005A!/\u001a8eKJ,'/\u0003\u0002\u001c1\tyA)\u001a4bk2$(+\u001a8eKJ,'\u000fC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0003?\u0005\u0002\"\u0001\t\u0001\u000e\u0003\tAQ!\u0006\u000fA\u0002YA#\u0001H\u0012\u0011\u0005\u0011zS\"A\u0013\u000b\u0005\u0019:\u0013AC1o]>$\u0018\r^5p]*\u0011\u0001&K\u0001\bM\u0006\u001cGo\u001c:z\u0015\tQ3&A\u0003cK\u0006t7O\u0003\u0002-[\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001/\u0003\ry'oZ\u0005\u0003a\u0015\u0012\u0011\"Q;u_^L'/\u001a3\t\u000bI\u0002A\u0011A\u001a\u0002\u001d\u0015D\bo\u001c:u)\u0016l\u0007\u000f\\1uKR!AgN J!\tyQ'\u0003\u00027!\t!QK\\5u\u0011\u0015A\u0014\u00071\u0001:\u0003!!X-\u001c9mCR,\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0007\u0003\u0019!w.\\1j]&\u0011ah\u000f\u0002\b%\u0016dW-Y:f\u0011\u0015\u0001\u0015\u00071\u0001B\u00031yW\u000f\u001e9viN#(/Z1n!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0002j_*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001dQ\u0015\u0007%AA\u0002-\u000b\u0001C]3oI\u0016\u0014\u0018i\u001d+f[Bd\u0017\r^3\u0011\u0005=a\u0015BA'\u0011\u0005\u001d\u0011un\u001c7fC:D#!M(\u0011\u0005A3V\"A)\u000b\u0005\u0019\u0012&BA*U\u0003\u001diW\r\u001e:jGNT!!\u0016\u0006\u0002\u0011\r|G-\u00195bY\u0016L!aV)\u0003\u000bQKW.\u001a3\t\u000be\u0003A\u0011\u0002.\u0002\u0015\u0005$G\r\u00177s)\u0006<7\u000f\u0006\u0002\\MB\u0011Al\u0019\b\u0003;\u0006\u0004\"A\u0018\t\u000e\u0003}S!\u0001\u0019\u0007\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0007#\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012\u0011\u0011\u00159\u0007\f1\u0001\\\u0003-!X-\u001c9mCR,Gi\u001d7\t\u000b%\u0004A\u0011\u00026\u0002%\u0005$G-T3uC&sgm\u001c:nCRLwN\u001c\u000b\u00047.d\u0007\"\u0002\u001di\u0001\u0004I\u0004\"B4i\u0001\u0004Y\u0006b\u00028\u0001#\u0003%\ta\\\u0001\u0019Kb\u0004xN\u001d;UK6\u0004H.\u0019;fI\u0011,g-Y;mi\u0012\u001aT#\u00019+\u0005-\u000b8&\u0001:\u0011\u0005M<X\"\u0001;\u000b\u0005U4\u0018!C;oG\",7m[3e\u0015\t1\u0003#\u0003\u0002yi\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3)\u0005\u0001Q\bCA>\u007f\u001b\u0005a(BA?,\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003\u007fr\u0014\u0011bQ8na>tWM\u001c;")
public class DslExporter {
    private final DefaultRenderer defaultRenderer;

    @Timed
    public void exportTemplate(Release template, OutputStream outputStream, boolean renderAsTemplate) {
        DslRendererContext rendererContext = new DslRendererContext(renderAsTemplate);
        String templateDsl = this.addXlrTags(this.defaultRenderer.dsl(rendererContext, (ConfigurationItem)template));
        String dslOut = this.addMetaInformation(template, DslFormatter$.MODULE$.format((String)new StringOps(Predef$.MODULE$.augmentString(rendererContext.context())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(templateDsl)), Predef$.MODULE$.StringCanBuildFrom())));
        StreamUtils.copy((String)dslOut, (Charset)StandardCharsets.UTF_8, (OutputStream)outputStream);
    }

    public boolean exportTemplate$default$3() {
        return true;
    }

    private String addXlrTags(String templateDsl) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xlr {\n       |", "\n       |}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateDsl})))).stripMargin();
    }

    private String addMetaInformation(Release template, String templateDsl) {
        String templateId = Ids.releasePathInRootFolder((String)template.getId()).replaceAll("/", "-");
        ReleaseInfo releaseInfo = new ReleaseInfo("com/xebialabs/deployit/release.properties");
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|// Exported from:        ", "#/templates/", "/releasefile\n        |// XL Release version:   ", "\n        |// Date created:         ", "\n        |\n        |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ServerConfiguration.getInstance().getServerUrl(), templateId, releaseInfo.getVersion(), new Date(), templateDsl})))).stripMargin();
    }

    @Autowired
    public DslExporter(DefaultRenderer defaultRenderer) {
        this.defaultRenderer = defaultRenderer;
    }
}

