/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.artifact.ArtifactEnricher;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.CreatedFromDsl;
import com.xebialabs.xlrelease.domain.events.PermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.dsl.service.CiProcessor;
import com.xebialabs.xlrelease.dsl.service.CiTreeVisitor;
import com.xebialabs.xlrelease.dsl.service.DslProcessingContext;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseCreateCommand;
import com.xebialabs.xlrelease.repository.ReleaseUpdateCommand;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.repository.XlrRepositoryCommand;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseEditor;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DslService
implements ApiService {
    private static final Logger logger = LoggerFactory.getLogger(DslService.class);
    private Teams teamRepository;
    private WorkDirFactory workDirFactory;
    private CiIdService ciIdService;
    private FolderService folderService;
    private CiProcessor ciProcessor;
    private PasswordEncrypter passwordEncrypter;
    private PermissionChecker permissionChecker;
    private ReleaseEditor releaseEditor;
    private ReleaseActorService releaseActorService;
    private XLReleaseEventBus eventBus;
    private XlrRepository xlrRepository;

    @Autowired
    public DslService(WorkDirFactory workdirFactory, CiIdService ciIdService, Teams teamRepository, FolderService folderService, CiProcessor ciProcessor, PasswordEncrypter passwordEncrypter, PermissionChecker permissionChecker, ReleaseEditor releaseEditor, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus, XlrRepository xlrRepository) {
        this.ciIdService = ciIdService;
        this.workDirFactory = workdirFactory;
        this.teamRepository = teamRepository;
        this.folderService = folderService;
        this.ciProcessor = ciProcessor;
        this.passwordEncrypter = passwordEncrypter;
        this.permissionChecker = permissionChecker;
        this.releaseEditor = releaseEditor;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
        this.xlrRepository = xlrRepository;
    }

    public Release createRelease(Release parentRelease, Release release) {
        DslProcessingContext processingContext = new DslProcessingContext();
        if (parentRelease == null || Ids.isInRootFolder((String)parentRelease.getId())) {
            this.permissionChecker.check(XLReleasePermissions.CREATE_RELEASE);
        } else {
            this.permissionChecker.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, parentRelease.getId());
        }
        if (release.getOwner() == null && parentRelease != null) {
            release.setOwner(parentRelease.getScriptUsername());
        }
        Directory container = null;
        if (null != parentRelease) {
            processingContext.setParentRelease(parentRelease);
            container = this.getContainer(parentRelease.getId());
        }
        this.applyReleaseAdminPermissionsIfNeeded(parentRelease, release);
        release.setStatus(ReleaseStatus.PLANNED);
        this.create((ConfigurationItem)container, (ConfigurationItem)release, release.getTeams(), processingContext);
        LocalDateTime releaseStart = release.getScheduledStartDate() != null ? LocalDateTime.fromDateFields((Date)release.getScheduledStartDate()) : LocalDateTime.now();
        this.releaseEditor.setDatesFromTemplate(release, release, releaseStart);
        this.encryptPasswords((ConfigurationItem)release);
        this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseUpdateCommand(release, release, release.getVariables()));
        this.releaseActorService.activate(release.getId());
        this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, (ReleaseCreationSource)new CreatedFromDsl(processingContext.getIdCounter().get())));
        this.eventBus.publish((XLReleaseEvent)new PermissionsUpdatedEvent(release.getTeams()));
        return release;
    }

    private void applyReleaseAdminPermissionsIfNeeded(Release parent, Release release) {
        if (release.getTeams().isEmpty() && !Ids.isInFolder((String)parent.getId())) {
            Team releaseAdminTeam = new Team();
            releaseAdminTeam.setTeamName("Release Admin");
            XLReleasePermissions.getReleasePermissions().forEach(arg_0 -> ((Team)releaseAdminTeam).addPermission(arg_0));
            releaseAdminTeam.addMember(parent.getScriptUsername());
            release.addTeam(releaseAdminTeam);
        }
    }

    private ConfigurationItem encryptPasswords(ConfigurationItem item) {
        logger.debug("Encrypting password properties of `{}`", (Object)item.getId());
        CiTreeVisitor.of(item).with(ci -> CiHelper.forFields((ConfigurationItem)ci, PropertyDescriptor::isPassword, this::encrypt));
        return item;
    }

    private void encrypt(ConfigurationItem ci, PropertyDescriptor pd) {
        logger.debug("Encrypting password property `{}` of `{}`", (Object)pd.getFqn(), (Object)ci.getId());
        String passwordValue = (String)pd.get(ci);
        if (passwordValue != null) {
            String encryptedValue = this.passwordEncrypter.ensureEncrypted(passwordValue);
            pd.set(ci, (Object)encryptedValue);
        }
    }

    private Directory getContainer(String id) {
        String releaseId = Ids.releaseIdFrom((String)id);
        String parentId = Ids.getParentId((String)releaseId);
        if (Ids.isRoot((String)parentId)) {
            return null;
        }
        return this.folderService.findById(parentId, Integer.valueOf(0));
    }

    private void create(ConfigurationItem parentContainer, ConfigurationItem ci, List<Team> teams, DslProcessingContext processingContext) {
        processingContext.setContainer(parentContainer);
        this.createCis(this.getNestedCisAndPopulateWithId(parentContainer, ci, processingContext), teams, processingContext);
    }

    private void createCis(List<ConfigurationItem> cis, List<Team> teams, DslProcessingContext processingContext) {
        List<Variable> newVariables = this.buildVariablesIfNeeded(cis);
        cis.addAll(newVariables);
        this.createCisAttachmentsAndNoTeams(cis, processingContext);
        this.saveTeams(teams);
    }

    private List<ConfigurationItem> getNestedCisAndPopulateWithId(ConfigurationItem parent, ConfigurationItem ci, DslProcessingContext processingContext) {
        ArrayList<ConfigurationItem> listWithNested = new ArrayList<ConfigurationItem>();
        listWithNested.add(ci);
        this.createId(ci, parent, processingContext);
        this.ciProcessor.process(processingContext, ci);
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            ConfigurationItem ciRef;
            PropertyKind kind = property.getKind();
            if (kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
                Collection<ConfigurationItem> children = this.getChildren(ci, property);
                listWithNested.addAll(this.getNestedCis(ci, children, processingContext));
            }
            if (kind != PropertyKind.CI || (ciRef = (ConfigurationItem)property.get(ci)) == null) continue;
            if (this.isChild(ciRef, ci)) {
                listWithNested.addAll(this.getNestedCisAndPopulateWithId(ci, ciRef, processingContext));
                continue;
            }
            if (property.getReferencedType().instanceOf(Type.valueOf(PythonScript.class))) {
                listWithNested.addAll(this.getNestedCisAndPopulateWithId(ci, ciRef, processingContext));
                continue;
            }
            this.resolveCiRef(ci, property, ciRef);
        }
        return listWithNested;
    }

    private void resolveCiRef(ConfigurationItem parentCi, PropertyDescriptor property, ConfigurationItem ciRef) {
        property.set(parentCi, (Object)ciRef);
    }

    private List<ConfigurationItem> getNestedCis(ConfigurationItem parent, Collection<? extends ConfigurationItem> cis, DslProcessingContext processingContext) {
        ArrayList<ConfigurationItem> listWithNested = new ArrayList<ConfigurationItem>();
        for (ConfigurationItem configurationItem : cis) {
            listWithNested.addAll(this.getNestedCisAndPopulateWithId(parent, configurationItem, processingContext));
        }
        return listWithNested;
    }

    private Collection<ConfigurationItem> getChildren(ConfigurationItem parent, PropertyDescriptor property) {
        Collection references = (Collection)property.get(parent);
        if (property.isAsContainment()) {
            return references;
        }
        return references.stream().filter(ci -> this.isChild((ConfigurationItem)ci, parent)).collect(Collectors.toList());
    }

    private boolean isChild(ConfigurationItem ci, ConfigurationItem parent) {
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyKind kind = property.getKind();
            if (kind != PropertyKind.CI || !property.isAsContainment() || !parent.equals(property.get(ci))) continue;
            return true;
        }
        return false;
    }

    private String createId(ConfigurationItem ci, ConfigurationItem parent, DslProcessingContext processingContext) {
        String parentId = null == parent ? Ids.ROOT_FOLDER_ID : parent.getId();
        String id = ci.getType().instanceOf(Type.valueOf(Release.class)) ? this.ciIdService.getGloballyUniqueId(ci.getType(), parentId) : this.ciIdService.getUniqueId(ci.getType(), parentId, processingContext.getIdCounter());
        ci.setId(id);
        return id;
    }

    private void createCisAttachmentsAndNoTeams(List<ConfigurationItem> cis, DslProcessingContext processingContext) {
        List cisWithoutTeams = cis.stream().filter(ci -> !ci.getType().instanceOf(Type.valueOf(Team.class))).collect(Collectors.toList());
        WorkDir workDir = this.workDirFactory.newWorkDir("external");
        WorkDirTemplate.cleanOnFinally((WorkDir)workDir, workDir1 -> {
            this.enrichSourceArtifacts(cisWithoutTeams, workDir1);
            cisWithoutTeams.forEach(ci -> {
                if (ci instanceof Release) {
                    this.xlrRepository.handle((XlrRepositoryCommand)new ReleaseCreateCommand((Release)ci, (ReleaseCreationSource)new CreatedFromDsl(processingContext.getIdCounter().get())));
                }
            });
            return null;
        });
    }

    private void enrichSourceArtifacts(List<ConfigurationItem> cisWithoutTeams, WorkDir workDir) {
        for (ConfigurationItem ci : cisWithoutTeams) {
            if (!(ci instanceof SourceArtifact)) continue;
            SourceArtifact sourceArtifact = (SourceArtifact)ci;
            if (sourceArtifact.getFileUri() != null) {
                new ArtifactEnricher((Artifact)sourceArtifact, workDir).enrich();
                continue;
            }
            throw new IllegalStateException(String.format("Unable to create source artifact for %s", sourceArtifact.getId()));
        }
    }

    private List<Variable> buildVariablesIfNeeded(List<ConfigurationItem> entities) {
        return entities.stream().filter(entity -> entity.getType().equals((Object)Type.valueOf(Release.class))).flatMap(entity -> {
            Release release = (Release)entity;
            return VariablePersistenceHelper.scanAndBuildNewVariables((Release)release, (VisitableItem)release, (CiIdService)this.ciIdService).stream();
        }).collect(Collectors.toList());
    }

    private void saveTeams(Collection<Team> entities) {
        HashMap<String, List> containersToTeams = new HashMap<String, List>();
        entities.forEach(team -> {
            String containerId = Ids.getParentId((String)team.getId());
            containersToTeams.computeIfAbsent(containerId, s -> new ArrayList()).add(team);
        });
        containersToTeams.forEach((containerId, containerTeams) -> this.teamRepository.saveTeamsToPlatform(containerId, containerTeams));
    }

    public String serviceName() {
        return "dsl";
    }
}

