package com.xebialabs.xlrelease.dsl.service.renderer

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import org.springframework.beans.factory.annotation.Autowired

trait DelegatingDslRenderer extends BaseCiRenderer {
  private[this] var defaultRenderer: DefaultRenderer = _

  def getDefaultRenderer: DefaultRenderer = this.defaultRenderer

  @Autowired
  def setDefaultRenderer(defaultRenderer: DefaultRenderer): Unit = this.defaultRenderer = defaultRenderer

  override def renderCi(rendererContext: DslRendererContext, ci: ConfigurationItem): String = defaultRenderer.dsl(rendererContext, ci)
}
