package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.Release
import groovy.transform.TypeChecked

/**
 * Release builder to create a Release
 */
@TypeChecked
class ReleaseBuilder {

  /**
   * Creates a Release with title and properties.
   *
   * @see #release(groovy.lang.Closure)
   */
  Release release(String title = null, @DelegatesTo(value = ReleaseSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    ReleaseSpec.delegate(new ReleaseSpec(title), cl)
  }
}