package com.xebialabs.xlrelease.export

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.dsl.service.DslExporter
import com.xebialabs.xlrelease.export.ReleasefileExporter.RELEASEFILE_FILENAME
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import org.springframework.util.StreamUtils.copy

import java.io.OutputStream
import java.nio.charset.StandardCharsets
import java.util.zip.{ZipEntry, ZipOutputStream}
import scala.util.Using

@Service
class ReleasefileExporter @Autowired()(dslExporter: DslExporter) {

  def exportZippedWithAttachments(template: Release, asTemplate: Boolean, outputStream: OutputStream): Unit = {
    Using.resource(new ZipOutputStream(outputStream)) { zipOutputStream =>
      TemplateExportHelper.addArtifacts(template, zipOutputStream)

      zipOutputStream.putNextEntry(new ZipEntry(RELEASEFILE_FILENAME))
      copy(exportAsString(template, asTemplate), StandardCharsets.UTF_8, zipOutputStream)
      zipOutputStream.closeEntry()
    }
  }

  def exportAsReleasefile(template: Release, asTemplate: Boolean, outputStream: OutputStream): Unit =
    copy(exportAsString(template, asTemplate), StandardCharsets.UTF_8, outputStream)

  def exportAsString(template: Release, asTemplate: Boolean): String = dslExporter.exportTemplate(template, asTemplate)
}

object ReleasefileExporter {
  val RELEASEFILE_FILENAME = "Releasefile.groovy"
}
