package com.xebialabs.xlrelease.dsl.service

import com.google.common.base.Strings

package object renderer {
  def string(value: String): String = {
    val r = for {
      line <- value.linesWithSeparators
    } yield s"'${escape(line)}'"
    val rendered = r.mkString(" +\n")
    if (Strings.isNullOrEmpty(rendered)) "''" else rendered
  }

  private def escape(value: String): String = {
    value.replace("\\", "\\\\").replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r")
  }
}
