package com.xebialabs.xlrelease.dsl.service.renderer

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Lazy, Primary}
import org.springframework.stereotype.Component

import java.util
import scala.jdk.CollectionConverters._


@Primary
@Component
class DefaultRenderer extends DslRenderer {

  lazy val dslRenderers: Map[Type, DslRenderer] = renderers.asScala.map(r => r.getType -> r).toMap

  override def dsl(rendererContext: DslRendererContext, ci: ConfigurationItem): String =  {
    val superTypes = Seq(ci.getType) ++ ci.getType.getDescriptor.getSuperClasses.asScala
    val renderer = superTypes collectFirst {
      case t if dslRenderers.contains(t) => dslRenderers.get(t).orNull
    }
    renderer.map(_.dsl(rendererContext, ci)).getOrElse(s"// no DSL renderer found for ${ci.getType}")
  }

  override def getType: Type = Type.valueOf(classOf[ConfigurationItem])

  private[this] var renderers: java.util.List[DslRenderer] = new util.ArrayList[DslRenderer]()

  def getRenderers: util.List[DslRenderer] = this.renderers

  @Autowired
  @Lazy
  def setRenderers(renders: java.util.List[DslRenderer]): Unit = this.renderers = renders
}
