package com.xebialabs.xlrelease.dsl.service.renderer

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import scala.reflect.runtime.universe._

class BaseTypedCiRenderer[T <: ConfigurationItem](val dslKeyword: String)(implicit clazzTag: TypeTag[T]) extends DslRenderer with DelegatingDslRenderer {

  private val clazz = runtimeMirror(this.getClass.getClassLoader).runtimeClass(clazzTag.tpe.typeSymbol.asClass)

  override def getType: Type = Type.valueOf(clazz)

  override def dsl(rendererContext: DslRendererContext, ci: ConfigurationItem): String = {
    s"""|$dslKeyword${renderTitle(ci)} {
        |${renderProperties(rendererContext, ci)}
        |}""".stripMargin
  }

  def renderTitle(ci: ConfigurationItem): String = if (ci.hasProperty("title")) s"(${string(ci.getProperty("title"))})" else ""
}
