package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.PollType
import com.xebialabs.xlrelease.domain.ReleaseTrigger
import groovy.transform.TypeChecked

@TypeChecked
class ReleaseTriggerSpec<T extends ReleaseTrigger> extends ConfigurationItemSpec<T> {

  ReleaseTriggerSpec(String title, Type ciType) {
    super(ciType)
    this.title(title)
  }

  /**
   * Name given to this trigger.
   *
   * @param title
   */
  void title(String title) {
    configurationItem.title = title
  }

  /**
   * Name given to releases created by this trigger.
   *
   * @param releaseTitle
   */
  void releaseTitle(String releaseTitle) {
    configurationItem.releaseTitle = releaseTitle
  }

  /**
   * Type of polling to use; this is a repeatable period in seconds (for example, every 10 seconds) or a cron expression.
   *
   * @param pollType pollType
   */
  void pollType(PollType pollType) {
    configurationItem.pollType = pollType
  }

  /**
   * Interval in seconds (REPEAT) or as a cron expression (CRON).
   *
   * @param periodicity
   */
  void periodicity(String periodicity) {
    configurationItem.periodicity = periodicity
  }

  void enabled(boolean enabled) {
    configurationItem.enabled = enabled
  }

  void tags(String... tags) {
    configurationItem.setTags((tags as Set) as List)
  }

  void variables(@DelegatesTo(value = VariablesDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    def variables = configurationItem.getVariables().collect()
    variables.addAll(VariablesDelegate.delegate(new VariablesDelegate(), cl))
    configurationItem.setVariables(variables)
  }
}
