package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard
import groovy.transform.TypeChecked

@TypeChecked
class DashboardReleaseExtensionSpec extends ReleaseExtensionSpec<Dashboard> {
  DashboardReleaseExtensionSpec(String title) {
    super(Type.valueOf(Dashboard))
    this.title(title)
  }

  void tiles(@DelegatesTo(value = TilesDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    configurationItem.tiles = TilesDelegate.delegate(new TilesDelegate(), cl)
  }

  void title(String title) {
    configurationItem.title = title
  }
}