package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.GroovyScriptTask
import groovy.transform.TypeChecked
import org.codehaus.groovy.runtime.StringGroovyMethods

@TypeChecked
class GroovyScriptTaskSpec extends TaskSpec<GroovyScriptTask> {

  GroovyScriptTaskSpec(String title = null) {
    super(title, Type.valueOf(GroovyScriptTask))
  }

  void script(String script) {
    configurationItem.script = script
  }

  void script(List<String> script) {
    configurationItem.script = StringGroovyMethods.stripIndent((CharSequence) script.join(""))
  }

  void script(String... script) {
    configurationItem.script = StringGroovyMethods.stripIndent((CharSequence) script.join(""))
  }

}
