package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.api.internal.InternalMetadata
import com.xebialabs.xlrelease.domain.Dependency
import com.xebialabs.xlrelease.domain.PlanItem
import com.xebialabs.xlrelease.variable.VariableHelper
import groovy.transform.TupleConstructor
import groovy.transform.TypeChecked

@TypeChecked
class DependencySpec extends ConfigurationItemSpec<Dependency> {
  DependencySpec() {
    super(Type.valueOf(Dependency))
  }

  /**
   * Specify a variable as the dependency.
   */
  void variable(String variable) {
    // TODO think of a proper name and place(should be inside/outside target) for this as it translates into a targetID
    configurationItem.setTargetId(VariableHelper.withVariableSyntax(variable))
  }

  /**
   * Specify block that defines dependency target.
   *
   * For example:
   *
   * <pre>
   *   target {
   *     release 'Release title'
   *     phase   'Phase title'
   *     task    'Task title'
   *   }
   * </pre>
   */
  void target(@DelegatesTo(value = DependencyTargetSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    def spec = new DependencyTargetSpec()
    def code = cl.rehydrate(spec, spec, spec)
    cl.resolveStrategy = Closure.DELEGATE_ONLY
    code()
    // assign release, phase and a task to metadata
    // The fact that spec implements InternalMetadata interface lets us assign metadata to configurationItem here
    configurationItem.$metadata['targetSpec'] = spec
  }

  /**
   * Specify PlanItem (Release, Phase or Task) as the dependency target.
   */
  void target(PlanItem targetPlanItem) {
    configurationItem.target = targetPlanItem
  }

  /**
   * Specify PlanItem (Release, Phase or Task) ID as the dependency target.
   */
  void target(String targetPlanItemId) {
    configurationItem.$metadata['targetSpec'] = new IdDependencyTargetSpec(targetId: targetPlanItemId)
  }

}
