package com.xebialabs.xlrelease.dsl.service

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.PythonScript
import com.xebialabs.xlrelease.dsl.resolver.DeliveryTaskFromPathResolver
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component


@Component
class DeliveryTaskCiProcessor @Autowired()(val deliveryTaskFromPathResolver: DeliveryTaskFromPathResolver) extends CiProcessor[PythonScript] {

  import com.xebialabs.xlrelease.dsl.resolver.DeliveryTaskPathResolver._

  override def getType: Type = Type.valueOf(deliveryTaskType)

  override def process(processingContext: DslProcessingContext, ci: PythonScript): Unit = {
    val resolutions = deliveryTaskFromPathResolver.resolve(ci)
    resolutions.foreach { case (propertyDescriptor, change) => propertyDescriptor.set(ci, change.newValue.get) }
  }

}
