package com.xebialabs.xlrelease.dsl.service.renderer

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.Configuration
import com.xebialabs.xlrelease.dsl.service.renderer.DslRendererContext._
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.service.{FolderService, ReleaseService}

import java.util
import scala.jdk.CollectionConverters._

class DslRendererContext(renderAsTemplate: Boolean = false,
                         val releaseService: ReleaseService,
                         val folderService: FolderService,
                         val configurationRepository: ConfigurationRepository) extends PathRenderingSupport {

  val ciReferences: util.Map[String, ConfigurationItem] = new util.LinkedHashMap[String, ConfigurationItem]

  var currentCiVariableMapping: util.Map[String, String] = new util.LinkedHashMap[String, String]()

  var ancestors: List[ConfigurationItem] = List()

  def parent: Option[ConfigurationItem] = ancestors.lift(1)

  def shouldRenderAsTemplate: Boolean = renderAsTemplate

  def context(): String = {
    var dslContext = ""

    if (ciReferences.values.asScala.exists(_.isServer)) {
      dslContext +=
        """def server(type, title, folderPath = null) {
          |  def folderId = null
          |  if(folderPath) {
          |      folderId = folderApi.find(folderPath, 0).getId()
          |  }
          |  def cis = configurationApi.searchByTypeAndTitle(type, title, folderId)
          |  if (cis.isEmpty()) {
          |    throw new RuntimeException("No CI found for the type '${type}' and title '${title}'")
          |  }
          |  if (cis.size() > 1) {
          |    throw new RuntimeException("More than one CI found for the type '${type}' and title '${title}'")
          |  }
          |  cis.get(0)
          |}
          |
          |""".stripMargin.replace("\r", "")
    }

    ciReferences
      .keySet.asScala
      .foreach(key => {
        val functionDef = ciReferences.get(key) match {
          case ci: Configuration if ci.isServer => {
            val updatedCi = configurationRepository.read(ci.getId).asInstanceOf[Configuration]
            s"def $key = server('${ci.getType}','${ci.getTitle}'" +
              s"${Option(updatedCi.getFolderId).map(p => getFolderPath(p).mkString(",'", "", "'")).getOrElse("")})"
          }
          case _ => s"def $key = 'PLEASE IMPLEMENT THIS METHOD'"
        }
        dslContext += functionDef ++ "\n"
      })

    if (ciReferences.values().asScala.nonEmpty) dslContext += "\n"

    dslContext
  }

  private def getFolderPath(id: String): String = {
    renderFolder(id).dropRight(1)
  }
}

object DslRendererContext {

  implicit class ConfigurationItemExtension(ciRef: ConfigurationItem) {
    def isRiskProfile = ciRef.getType.instanceOf(Type.valueOf("xlrelease.RiskProfile"))

    def isServer = ciRef.isInstanceOf[Configuration]
  }

}
