package com.xebialabs.xlrelease.dsl.service.renderer

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.ReleaseTrigger
import org.springframework.stereotype.Component

@Component
class ReleaseTriggersRenderer extends BaseTypedCiRenderer[ReleaseTrigger]("releaseTrigger") {

  override def ignoredProperties = List("title", "triggerState", "executionId", "template")

  override protected def shouldRender(rendererContext: DslRendererContext, ci: ConfigurationItem, pd: PropertyDescriptor): Boolean = {
    val isNotOutputVariables = "variables" != pd.getCategory
    super.shouldRender(rendererContext, ci, pd) && isNotOutputVariables
  }

  override def dsl(rendererContext: DslRendererContext, ci: ConfigurationItem): String = {
    val dslKeyword = ci.getType.toString.replace(".", "")

    s"""|$dslKeyword${renderTitle(ci)} {
        |${renderProperties(rendererContext, ci)}
        |}""".stripMargin
  }
}
