package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.CreateReleaseTask
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.variable.VariableHelper
import groovy.transform.TypeChecked

@TypeChecked
class CreateReleaseTaskSpec extends TaskSpec<CreateReleaseTask> {

  CreateReleaseTaskSpec(String title = null) {
    super(title, Type.valueOf(CreateReleaseTask))
  }

  /**
   * Title of the release to create.
   */
  void newReleaseTitle(String newReleaseTitle) {
    configurationItem.newReleaseTitle = newReleaseTitle
  }

  /**
   * Immediately start the release after it is created if true. Default value: true.
   */
  void startRelease(boolean startRelease) {
    configurationItem.startRelease = startRelease
  }

  /**
   * Template that will be used to create a release.
   */
  void template(String filter) {
    configurationItem.templateId = filter
  }

  /**
   * The folder in which to create the release in.
   */
  void folder(String folder) {
    configurationItem.folderId = folder;
  }

  /**
   * Tags that will be propagated to created release.
   */
  void releaseTags(String ... releaseTags) {
    configurationItem.releaseTags = releaseTags.toList().toSet()
  }

  /**
  * Define variables for the template used for the release
  */
  void templateVariables(@DelegatesTo(value = VariablesDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    def variables = configurationItem.getTemplateVariables().collect()
    def variablesDelegate = new VariablesDelegate()
    variables.addAll(VariablesDelegate.delegate(variablesDelegate, cl))
    configurationItem.setTemplateVariables(variables)
    variables.eachWithIndex { Variable var, int idx ->
      def varRef = variablesDelegate.variableRefSpecs.find { varRef -> varRef.variableKey == var.key }
      if (varRef) {
        configurationItem.variableMapping["templateVariables[$idx].value" as String] = VariableHelper.withVariableSyntax(varRef.variableName)
      }
    }
  }

  /**
   * ID of the release created from this task (output property).
   */
  void createdReleaseId(VariableRefSpec variableRefSpec) {
    variableRefSpec.setPropertyName("createdReleaseId")

    def variableName = VariableHelper.formatVariableIfNeeded(variableRefSpec.variableName)
    configurationItem.setCreatedReleaseId(variableName)
  }
}
