package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.UserInputTask
import com.xebialabs.xlrelease.dsl.service.DslError
import com.xebialabs.xlrelease.variable.VariableHelper
import groovy.transform.TypeChecked

@TypeChecked
class UserInputTaskSpec extends TaskSpec<UserInputTask> {

  UserInputTaskSpec(String title = null) {
    super(title, Type.valueOf(UserInputTask))
  }

  void variables(@DelegatesTo(value = UserInputVariablesDelegate, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    def collectionDelegate = new UserInputVariablesDelegate()
    def code = cl.rehydrate(collectionDelegate, collectionDelegate, collectionDelegate)
    cl.resolveStrategy = Closure.DELEGATE_ONLY
    code()
    def variableMap = configurationItem.getRelease().getVariablesByKeys()
    collectionDelegate.variableNames.forEach { String key ->
      String variableKey = VariableHelper.withoutVariableSyntax(key)
      if (!variableMap.containsKey(variableKey)) {
        throw new DslError("Variable '%s' is not defined on a release of task '%s'", key, this.configurationItem.title)
      }
      def releaseVariable = variableMap[variableKey]
      this.configurationItem.variables.add(releaseVariable)
    }
  }
}
