package com.xebialabs.xlrelease.domain.tasks.groovy;

import java.util.List;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.GroovyScriptTask;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;

@Component
public class GroovyScriptTaskViewConverter extends BaseTaskViewConverter<GroovyScriptTask> {

    @Override
    public TaskFullView toFullView(final GroovyScriptTask task, final List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView v = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        v.setScript(task.getScript());
        return v;
    }

    @Override
    protected GroovyScriptTask fromView(final TaskFullView view) {
        GroovyScriptTaskBuilder builder = new GroovyScriptTaskBuilder();
        return builder.withScript(view.getScript()).build();
    }

    @Override
    protected Class<GroovyScriptTask> getTaskClass() {
        return GroovyScriptTask.class;
    }
}