package com.xebialabs.xlrelease.dsl.resolver

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.utils.syntax._
import com.xebialabs.xlrelease.variable.VariableHelper.containsOnlyVariable
import org.springframework.util.StringUtils.hasText

import scala.collection.mutable
import scala.util.Try

object DeliveryTaskPathResolver {
  val deliveryTaskType: String = "delivery.Task"

  val deliveryIdField: String = "deliveryId"
  val patternIdField: String = "patternId"
  val stageIdField: String = "stage"
  val folderIdField: String = "folderId"

  val fieldsWithFolderPath: List[String] = List(patternIdField, folderIdField)
}

trait DeliveryTaskPathResolver extends DslPathResolver {
  type Resolver = (ConfigurationItem, String, String, mutable.Map[String, PathResolution]) => String

  protected def resolveCi(ci: ConfigurationItem, resolvers: Seq[(String, Resolver)]): Map[PropertyDescriptor, PathResolution] = {
    val resolutions = mutable.Map[String, PathResolution]()

    resolvers.foreach { case (property, resolver) =>
      resolveProperty(ci, property, resolutions)(resolver).foreach(change => resolutions.put(property, change))
    }

    resolutions.map { case (property, change) => (ci.getType.getDescriptor.getPropertyDescriptor(property), change) }.toMap
  }

  protected def resolveProperty(ci: ConfigurationItem,
                                property: String,
                                resolutions: mutable.Map[String, PathResolution])(resolver: Resolver): Option[PathResolution] =
    if (ci.hasProperty(property)) {
      val oldValue = ci.getPropertyOption[String](property)
      val newValue = Try(oldValue match {
        case Some(variable) if containsOnlyVariable(variable) => variable
        case Some(value) if hasText(value) => resolver(ci, property, value, resolutions)
        case Some(value) => value
        case _ => null
      })
      Some(PathResolution(oldValue.orNull, newValue))
    } else {
      None
    }
}
