package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Descriptor
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile
import groovy.transform.TypeChecked

@TypeChecked
class TilesDelegate {
  List<Tile> tiles = []

  def methodMissing(String name, args) {
    def arguments = args as Object[]
    Descriptor descriptor = DescriptorRegistry.getDescriptors().find { d ->
      name.toLowerCase() == d.type.name.toLowerCase()
    }

    if (descriptor != null) {
      def title = arguments[0] as String
      def cl = arguments[1] as Closure

      return pDelegate(new TileReleaseExtensionSpec(title, descriptor.type), cl)
    }

    throw new MissingMethodException(name, this.class, arguments)
  }

  static List<Tile> delegate(TilesDelegate tilesDelegate, Closure cl) {
    def code = cl.rehydrate(tilesDelegate, tilesDelegate, tilesDelegate)
    cl.resolveStrategy = Closure.DELEGATE_ONLY
    code()
    tilesDelegate.tiles
  }

  private TileReleaseExtensionSpec pDelegate(TileReleaseExtensionSpec tileReleaseExtensionSpec, Closure cl) {
    def code = cl.rehydrate(tileReleaseExtensionSpec, tileReleaseExtensionSpec, tileReleaseExtensionSpec)
    cl.resolveStrategy = Closure.DELEGATE_ONLY
    code()
    tileReleaseExtensionSpec.postProcess()
    Tile tile = tileReleaseExtensionSpec.getConfigurationItem()
    tiles.add(tile)
    tileReleaseExtensionSpec
  }
}