package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact
import com.xebialabs.xlrelease.domain.TemplateLogo
import groovy.transform.TypeChecked

@TypeChecked
class TemplateLogoSpec extends ConfigurationItemSpec<TemplateLogo> {

  TemplateLogoSpec(String fileUri = null) {
    super(Type.valueOf(TemplateLogo))
    this.fileUri(fileUri)
  }

  void fileUri(String fileUri) {
    configurationItem.setProperty(SourceArtifact.FILE_URI_PROPERTY_NAME, fileUri)
  }

  void filename(String filename) {
    configurationItem.setPortableFilename(filename)
  }
}