package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.ReleaseExtension
import groovy.transform.TypeChecked

/**
 * DSL representation for a collection of ReleaseExtensions
 */
@TypeChecked
class ReleaseExtensionsDelegate extends CollectionDelegate<Release, ReleaseExtension> {
  ReleaseExtensionsDelegate(Release container) {
    super(container)
  }

  ReleaseExtensionSpec extension(@DelegatesTo(value = DashboardReleaseExtensionSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new ReleaseExtensionSpec(), cl)
  }

  ReleaseExtensionSpec dashboard(String title = "", @DelegatesTo(value = DashboardReleaseExtensionSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new DashboardReleaseExtensionSpec(title), cl)
  }
}