package com.xebialabs.xlrelease.dsl

import com.xebialabs.xlrelease.domain.Attachment
import com.xebialabs.xlrelease.domain.PlanItem
import groovy.transform.TypeChecked

@TypeChecked
class AttachmentsDelegate<C extends PlanItem> extends CollectionDelegate<C, Attachment> {

  AttachmentsDelegate(C container) {
    super(container)
  }

  void attachment(String fileUri = null, @DelegatesTo(value = AttachmentSpec, strategy = Closure.DELEGATE_ONLY) Closure cl) {
    super.delegate(new AttachmentSpec(fileUri), cl)
  }

}