package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Descriptor
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.ReleaseTrigger
import groovy.transform.TypeChecked

/**
 * DSL representation for a collection of Triggers
 */
@TypeChecked
class ReleaseTriggersDelegate extends CollectionDelegate<Release, ReleaseTrigger> {

  ReleaseTriggersDelegate(Release release) {
    super(release)
  }

  def methodMissing(String name, args) {
    def arguments = args as Object[]
    Descriptor descriptor = DescriptorRegistry.getDescriptors().find { d ->
      name == d.type.toString().replace(".", "")
    }

    if (descriptor != null) {
      def title = arguments[0] as String
      def cl = arguments[1] as Closure

      return super.delegate(new ReleaseTriggerSpec(title, descriptor.type), cl)
    }

    throw new MissingMethodException(name, this.class, arguments)
  }
}