package com.xebialabs.xlrelease.dsl

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact
import com.xebialabs.xlrelease.domain.Attachment
import groovy.transform.TypeChecked

@TypeChecked
class AttachmentSpec extends ConfigurationItemSpec<Attachment> {

  AttachmentSpec(String fileUri = null) {
    super(Type.valueOf(Attachment))
    this.fileUri(fileUri)
  }

  void fileUri(String fileUri) {
    configurationItem.setProperty(SourceArtifact.FILE_URI_PROPERTY_NAME, fileUri)
  }

  void filename(String filename) {
    configurationItem.setExportFilename(filename)
  }
}
